/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.utils;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.utils.Vec3d;
import dev.lucaargolo.charta.utils.ZIPCompression;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CardImage {
    public static final int WIDTH = 25;
    public static final int HEIGHT = 35;
    public static final int[] COLOR_PALETTE = new int[]{0, 0x252525, 0x494949, 0x6E6E6E, 0x929292, 0xB7B7B7, 0xDCDCDC, 0xFFFFFF, 0x7F0000, 0xB20000, 0xE30000, 0xFF0000, 0xFF5353, 0xFF7575, 0xFF9898, 0xFFBABA, 8339200, 11687936, 14905344, 0xFF7F00, 16755027, 16759413, 16763800, 16768186, 0x7F7F00, 0xB2B200, 0xE3E300, 0xFFFF00, 0xFFFF53, 0xFFFF75, 0xFFFF98, 0xFFFFBA, 32512, 45568, 58112, 65280, 0x53FF53, 0x75FF75, 0x98FF98, 0xBAFFBA, 32639, 45746, 58339, 65535, 0x53FFFF, 0x75FFFF, 0x98FFFF, 0xBAFFFF, 127, 178, 227, 255, 0x5353FF, 0x7575FF, 0x9898FF, 0xBABAFF, 0x7F007F, 0xB200B2, 0xE300E3, 0xFF00FF, 0xFF53FF, 0xFF75FF, 0xFF98FF, 0xFFBAFF};
    public static final int[] ALPHA_PALETTE = new int[]{0, 85, 170, 255};
    private final byte[] pixels;
    private final int width;
    private final int height;
    private final int totalPixels;
    private int averageColor;

    public CardImage() {
        this(new byte[875], 25, 35);
    }

    private CardImage(byte[] pixels) {
        this(pixels, 25, 35);
    }

    protected CardImage(byte[] pixels, int width, int height) {
        this.pixels = pixels;
        this.width = width;
        this.height = height;
        this.totalPixels = width * height;
        double qnt = 0.0;
        Vec3d sum = new Vec3d(0.0, 0.0, 0.0);
        for (int i = 0; i < this.totalPixels; ++i) {
            byte pixelByte = pixels[i];
            int alphaIndex = pixelByte >> 6 & 3;
            int colorIndex = pixelByte & 0x3F;
            if (colorIndex == 0 && alphaIndex == 0) continue;
            sum = sum.add(Vec3d.fromRGB24(COLOR_PALETTE[colorIndex]));
            qnt += 1.0;
        }
        sum = sum.multiply(1.0 / qnt);
        int r = (int)(sum.getX() * 255.0) & 0xFF;
        int g = (int)(sum.getY() * 255.0) & 0xFF;
        int b = (int)(sum.getZ() * 255.0) & 0xFF;
        this.averageColor = r << 16 | g << 8 | b;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public CardImage copy() {
        CardImage copy = new CardImage();
        System.arraycopy(this.pixels, 0, copy.pixels, 0, this.totalPixels);
        copy.averageColor = this.averageColor;
        return copy;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.totalPixels; ++i) {
            byte pixelByte = this.pixels[i];
            int alphaIndex = pixelByte >> 6 & 3;
            int colorIndex = pixelByte & 0x3F;
            if (alphaIndex == 0 && colorIndex == 0) continue;
            return false;
        }
        return true;
    }

    public void setARGBPixel(int x, int y, int argb) {
        int rgb = argb & 0xFFFFFF;
        int alpha = argb >> 24 & 0xFF;
        this.setPixel(x, y, CardImage.findClosestColorIndex(rgb), CardImage.findClosestAlphaIndex(alpha));
    }

    public void setPixel(int x, int y, int colorIndex, int alphaIndex) {
        byte pixelByte;
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("Invalid pixel coordinates.");
        }
        if (colorIndex < 0 || colorIndex >= 64) {
            throw new IllegalArgumentException("Color index out of range.");
        }
        if (alphaIndex < 0 || alphaIndex >= 4) {
            throw new IllegalArgumentException("Alpha index out of range.");
        }
        this.pixels[y * this.width + x] = pixelByte = (byte)(alphaIndex << 6 | colorIndex & 0x3F);
    }

    public int getARGBGlowPixel(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("Invalid pixel coordinates.");
        }
        byte pixelByte = this.pixels[y * this.width + x];
        int alphaIndex = pixelByte >> 6 & 3;
        int colorIndex = pixelByte & 0x3F;
        int rgb = COLOR_PALETTE[colorIndex];
        if (colorIndex != 0 && alphaIndex == 0) {
            return 0xFF000000 | rgb & 0xFFFFFF;
        }
        return 0;
    }

    public int getARGBPixel(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("Invalid pixel coordinates.");
        }
        byte pixelByte = this.pixels[y * this.width + x];
        int alphaIndex = pixelByte >> 6 & 3;
        int colorIndex = pixelByte & 0x3F;
        int rgb = COLOR_PALETTE[colorIndex];
        int alpha = colorIndex != 0 && alphaIndex == 0 ? 255 : ALPHA_PALETTE[alphaIndex];
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public byte getPixel(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("Invalid pixel coordinates.");
        }
        return this.pixels[y * this.width + x];
    }

    public void saveToFile(String fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            this.saveToStream(fos);
        }
    }

    public void saveToStream(OutputStream stream) throws IOException {
        stream.write(this.compress());
    }

    public byte[] compress() {
        try {
            return ZIPCompression.compress(this.pixels);
        }
        catch (IOException exception) {
            Charta.LOGGER.error("Error compressing card image: ", (Throwable)exception);
            return new byte[0];
        }
    }

    public static CardImage loadFromFile(File file) throws IOException {
        return CardImage.loadFromFile(file, 25, 35, CardImage::new);
    }

    public static CardImage decompress(byte[] data) {
        return CardImage.decompress(data, 25, 35, CardImage::new);
    }

    public static void saveCards(BufferedImage image, File outputFile, BiConsumer<File, CardImage> saveConsumer) {
        CardImage.saveImages(image, 25, 35, outputFile, "mccard", saveConsumer);
    }

    protected static <I extends CardImage> I loadFromFile(File file, int width, int height, Function<byte[], I> function) throws IOException {
        I image;
        try (FileInputStream fis = new FileInputStream(file);){
            image = CardImage.decompress(fis.readAllBytes(), width, height, function);
        }
        return image;
    }

    protected static <I extends CardImage> I decompress(byte[] data, int width, int height, Function<byte[], I> function) {
        try {
            byte[] pixels = ZIPCompression.decompress(data);
            if (pixels.length != width * height) {
                throw new IOException("Invalid file size, expected " + width * height + " bytes.");
            }
            return (I)((CardImage)function.apply(pixels));
        }
        catch (IOException exception) {
            Charta.LOGGER.error("Error decompressing card image: ", (Throwable)exception);
            return (I)((CardImage)function.apply(null));
        }
    }

    protected static void saveImages(BufferedImage image, int width, int height, File outputFile, String extension, BiConsumer<File, CardImage> saveConsumer) {
        int cols;
        CardImage[] cards = CardImage.generateImages(image, width, height);
        int rows = image.getWidth() / width;
        if (rows == (cols = image.getHeight() / height) && cols == 1) {
            CardImage cardImage = cards[0];
            File fileToSave = new File(outputFile.getAbsolutePath() + "." + extension);
            saveConsumer.accept(fileToSave, cardImage);
        } else {
            for (int col = 0; col < cols; ++col) {
                for (int row = 0; row < rows; ++row) {
                    CardImage cardImage = cards[col * rows + row];
                    if (cardImage.isEmpty()) continue;
                    File folderToSave = new File(outputFile.getAbsolutePath());
                    folderToSave.mkdirs();
                    File fileToSave = new File(outputFile.getAbsolutePath() + File.separator + String.valueOf(cols == 1 ? Integer.valueOf(row) : col + "_" + row) + "." + extension);
                    saveConsumer.accept(fileToSave, cardImage);
                }
            }
        }
    }

    protected static CardImage[] generateImages(BufferedImage image, int width, int height) {
        int rows = image.getWidth() / width;
        int cols = image.getHeight() / height;
        CardImage[] cards = new CardImage[rows * cols];
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                CardImage cardImage = new CardImage(new byte[width * height], width, height);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int argb;
                        try {
                            argb = image.getRGB(x + row * width, y + col * height);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            argb = -1;
                        }
                        cardImage.setARGBPixel(x, y, argb);
                    }
                }
                cards[col * rows + row] = cardImage;
            }
        }
        return cards;
    }

    public static int findClosestColorIndex(int rgb) {
        int closestIndex = 0;
        int minDistance = Integer.MAX_VALUE;
        int r1 = rgb >> 16 & 0xFF;
        int g1 = rgb >> 8 & 0xFF;
        int b1 = rgb & 0xFF;
        for (int i = 0; i < COLOR_PALETTE.length; ++i) {
            int paletteColor = COLOR_PALETTE[i];
            int r2 = paletteColor >> 16 & 0xFF;
            int g2 = paletteColor >> 8 & 0xFF;
            int b2 = paletteColor & 0xFF;
            int distance = (r1 - r2) * (r1 - r2) + (g1 - g2) * (g1 - g2) + (b1 - b2) * (b1 - b2);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestIndex = i;
        }
        return closestIndex;
    }

    public static int findClosestAlphaIndex(int alpha) {
        int closestIndex = 0;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < ALPHA_PALETTE.length; ++i) {
            int distance = Math.abs(alpha - ALPHA_PALETTE[i]);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestIndex = i;
        }
        return closestIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CardImage)) {
            return false;
        }
        CardImage other = (CardImage)obj;
        return Arrays.equals(this.pixels, other.pixels);
    }

    public int hashCode() {
        return Arrays.hashCode(this.pixels);
    }

    public int getAverageColor() {
        return this.averageColor;
    }
}

